/******************************************************************************
 x_CCompilerListing.cp

				CCompilerListing Dialog Director Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory)

	This file is rewritten each time you generate code. You should not
	make changes to this file; changes should go in the CCompilerListing.c
	file, instead.

	If you want to change how Classy generates this file, you can
	change the template for this file. It is "_Director.c" in the Classy
	Templates folder.

 ******************************************************************************/

#include "x_CCompilerListing.h"

#include "CompilerListingItems.h"

#include "ViewUtilities.h"


#include "CEditText.h"
#include "CStaticText.h"

#include <CApplication.h>
#include <CBartender.h>
#include <Commands.h>
#include <Constants.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <CDirectorOwner.h>
#include <CFile.h>
#include <CList.h>
#include <CPanorama.h>
#include <TBUtilities.h>
#include <CWindow.h>

extern	CApplication *gApplication;		/* The application					*/
extern CDecorator	*gDecorator;		/* Decorator for arranging windows	*/
extern CDesktop		*gDesktop;			/* The visible Desktop				*/
extern CBartender	*gBartender;		/* Manages all menus				*/

	// Define symbols for commands handled by this class
	// Prevents a recompile every time any command changed.

#define cmdNextError 527
#define cmdPreviousError 528

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 I_CCompilerListing

	Initialize the director
 ******************************************************************************/

void x_CCompilerListing::Ix_CCompilerListing(CDirectorOwner *aSupervisor)

{
	IDirector(aSupervisor);

		// We don't want ProviderChanged called while the window
		// is being initialized, before the itsWindow variable
		// is set. The ignore flag is intended to prevent this.

	ignore = TRUE;						/* Stay out of ProviderChanged		*/

	MakeNewWindow();					/* Create the director's window		*/

	ignore = FALSE;
}


/******************************************************************************
 MakeNewWindow

	Create a window by reading a view resource
 ******************************************************************************/

void x_CCompilerListing::MakeNewWindow(void)

{
	itsWindow = CLGetNamedWindow("\pCompilerListing", this);

		// Initialize pointers to the subpanes in the window

  fCompilerListing_Pano1 = (CEditText*) FindPane(kCompilerListing_Pano1ID);
  ASSERT(member(fCompilerListing_Pano1, CEditText));

  fCompilerListing_Message = (CStaticText*) FindPane(kCompilerListing_MessageID);
  ASSERT(member(fCompilerListing_Message, CStaticText));

}


/******************************************************************************
 FindPane

	Locate a subpane of this window by ID. Note that Classy-
	generated IDs are unique within a project, so this function
	will find panes within subviews, even if dynamically loaded.
 ******************************************************************************/

CPane *x_CCompilerListing::FindPane(long ID)

{
	return (CPane*) itsWindow->FindViewByID(ID);
}


/******************************************************************************
 DoCommand {OVERRIDE}

		Dispatch Classy-specified actions.
 ******************************************************************************/

void x_CCompilerListing::DoCommand(long theCommand)

{
	switch (theCommand)
	{
		case cmdNextError:
			DoCmdNextError();
			break;
		case cmdPreviousError:
			DoCmdPreviousError();
			break;
		default:
			CDirector::DoCommand(theCommand);
	}
}


/******************************************************************************
 UpdateMenus {OVERRIDE}

		Enable menus which generate commands handled by this class.
 ******************************************************************************/

void x_CCompilerListing::UpdateMenus()

{
	CDirector::UpdateMenus();
	gBartender->EnableCmd(cmdNextError);
	gBartender->EnableCmd(cmdPreviousError);
}


/******************************************************************************
 DoCmdNextError

		Respond to cmdNextError command.
 ******************************************************************************/

void x_CCompilerListing::DoCmdNextError()

{
  		// Subclass must override this function to
  		// handle the command
}


/******************************************************************************
 DoCmdPreviousError

		Respond to cmdPreviousError command.
 ******************************************************************************/

void x_CCompilerListing::DoCmdPreviousError()

{
  		// Subclass must override this function to
  		// handle the command
}


